; Change CMOS RTC week of day value
; RTCDOW.S (Standalone Program for Real Mode)
; by Erdogan Tan (01/03/2015)
; ((Assembler: NASM 2.11))

; Last Update: 01/03/2015
;
;; Programming purpose:
;; Day of Week value (CMOS Register 6)
;; is (can) not changed/updated via ROM BIOS.
;; So, it is needed to change
;; this value with a special utility. 
;; (SUNDAY = 1, .... SATURDAY = 7)
;; If it is not changed, programs which
;; use Real Time Clock and CMOS Day Of Week value
;; will show wrong day but (with) correct date and time.
;; For example: 01/03/2015 (March 1, 2015)
;, is Sunday but my computer shows 'SAT' instead of
;; 'SUN' (ASUS M2TVM main board, AMD 64 Athlon CPU,
;;  AWARD BIOS, 2004).
;, The ROM BIOS uses internal calculation method
;; without regarding CMOS Day of Week (register) value.
;; It is not possible to change this CMOS register value
;  by using ROM BIOS.
;; 	
;, /// Assembly source code is modified from (dsectpm.s)
;; Retro UNIX 386 v1 DISK I/O Test program (unix386.s) - 28/02/2015 ///
;; (dsectrpm.s, dsectrm2.s, drvinit.inc, diskette.inc, disk.inc)

ESCKey	 equ 1Bh    ;27		
ENTERKey equ 0Dh    ;13

; IBM PC/XT Model 286 BIOS ----- 10/06/85 (postequ.inc)
;--------- CMOS TABLE LOCATION ADDRESS'S -------------------------------------
CMOS_SECONDS	EQU	00H		; SECONDS (BCD)
CMOS_MINUTES	EQU	02H		; MINUTES (BCD)	
CMOS_HOURS	EQU	04H		; HOURS (BCD)
CMOS_DAY_WEEK	EQU	06H		; DAY OF THE WEEK  (BCD)
CMOS_DAY_MONTH	EQU	07H		; DAY OF THE MONTH (BCD) 
CMOS_MONTH	EQU	08H		; MONTH (BCD)
CMOS_YEAR	EQU	09H		; YEAR (TWO DIGITS) (BCD)
CMOS_CENTURY	EQU	32H		; DATE CENTURY BYTE (BCD)
CMOS_REG_A	EQU	0AH		; STATUS REGISTER A
CMOS_REG_D	EQU	0DH		; STATUS REGISTER D  BATTERY
CMOS_SHUT_DOWN	EQU	0FH		; SHUTDOWN STATUS COMMAND BYTE
;----------------------------------------
;	CMOS EQUATES FOR THIS SYSTEM	;
;-----------------------------------------------------------------------------
CMOS_PORT	EQU	070H		; I/O ADDRESS OF CMOS ADDRESS PORT
CMOS_DATA	EQU	071H		; I/O ADDRESS OF CMOS DATA PORT
NMI		EQU	10000000B	; DISABLE NMI INTERRUPTS MASK -
					; HIGH BIT OF CMOS LOCATION ADDRESS
[BITS 16]

	org 100h
	;
        mov     si, prg_msg
print_msg:	
	mov	bx, 7
	mov	ah, 0Eh
prt_msg_loop:
	lodsb
	and	al, al
	jz	short getchar
	int 	10h
	jmp	short prt_msg_loop
getchar:
	mov	ah, 10h
	int	16h
	;
	cmp	al, ESCKey
	je      short rtcs_exit
	cmp	al, '1'
        jb      short getchar
	cmp	al, '7'
        ja	short getchar
	sub	al, '0'
	mov	bl, al
	shl 	bl, 2
	add	bx, daytmp
	mov	dx, word [bx]
	mov	word [daystr], dx
	mov	dx, word [bx+2]
	mov	word [daystr+2], dx
	mov	ah, CMOS_DAY_WEEK
	call	write_cmos
	jc	short rtcs_exit
        mov     si, dow_msg
pdow_msg:	
	mov	bx, 7
	mov	ah, 0Eh
pdow_msg_l:
	lodsb
	and	al, al
	jz	short rtcs_ok
	int 	10h
	jmp	short pdow_msg_l
rtcs_ok:
	mov 	ah, 10h
	int 	16h
rtcs_exit:
	int 	20h
	int	19h

nevercomehere:
	jmp	short nevercomehere

	; IBM PC/XT Model 286 BIOS source code ----- 10/06/85 (test4.asm)
CMOS_READ:			; READ LOCATION (AL) INTO (AL)
	PUSHF			; SAVE INTERRUPT ENABLE STATUS AND FLAGS
	ROL	AL,1		; MOVE NMI BIT TO LOW POSITION
	STC			; FORCE NMI BIT ON IN CARRY FLAG
	RCR	AL,1		; HIGH BIT ON TO DISABLE NMI - OLD IN CY
	CLI			; DISABLE INTERRUPTS
	OUT	CMOS_PORT,AL	; ADDRESS LOCATION AND DISABLE NMI
	NOP			; I/O DELAY
	IN	AL,CMOS_DATA	; READ THE REQUESTED CMOS LOCATION
	PUSH	AX		; SAVE (AH) REGISTER VALUE AND CMOS BYTE
	MOV	AL,CMOS_SHUT_DOWN*2 ; GET ADDRESS OF DEFAULT LOCATION
	RCR	AL,1		; PUT ORIGINAL NMI MASK BIT INTO ADDRESS
	OUT	CMOS_PORT,AL	; SET DEFAULT TO READ ONLY REGISTER
	NOP			; I/O DELAY
	IN	AL,CMOS_DATA	; OPEN STANDBY LATCH
	POP	AX		; RESTORE (AH) AND (AL), CMOS BYTE
	PUSH	CS		; *PLACE CODE SEGMENT IN STACK AND
	CALL	CMOS_POPF	; *HANDLE POPF FOR B- LEVEL 80286
	RETn			; RETURN WITH FLAGS RESTORED

CMOS_POPF:			; POPF FOR LEVEL B- PARTS
	IRET			; RETURN FAR AND RESTORE FLAGS	

write_cmos:
	xchg	ah, al		; al = location, ah = value
	push	ax
	;CALL	UPD_IPR		; CHECK FOR UPDATE IN PROCESS
	; IBM PC/XT Model 286 BIOS source code ----- 10/06/85 (bios2.asm)
UPD_IPR:			; WAIT TILL UPDATE NOT IN PROGRESS
	PUSH	CX		; SAVE CALLERS REGISTER
	;MOV	CX,800		; SET TIMEOUT LOOP COUNT
	xor	cx, cx
UPD_10:
	MOV	AL,CMOS_REG_A	; ADDRESS STATUS REGISTER A
	CLI			; NO TIMER INTERRUPTS DURING UPDATES
	CALL	CMOS_READ	; READ UPDATE IN PROCESS FLAG
	TEST	AL,80H		; IF UIP BIT IS ON ( CANNOT READ TIME )
	JZ	short UPD_90	; EXIT WITH CY= 0 IF CAN READ CLOCK NOW
	STI			; ALLOW INTERRUPTS WHILE WAITING
	LOOP	UPD_10		; LOOP TILL READY OR TIMEOUT
	XOR	AX,AX		; CLEAR RESULTS IF ERROR
	STC			; SET CARRY FOR ERROR
UPD_90:
	POP	CX		; RESTORE CALLERS REGISTER
	CLI			; INTERRUPTS OFF DURING SET
	;RETn			; RETURN WITH CY FLAG SET
	pop	ax
	jc	short cw_retn

	; IBM PC/XT Model 286 BIOS source code ----- 10/06/85 (test4.asm)
CMOS_WRITE:			; WRITE (AH) TO LOCATION (AL)
	PUSHF			; SAVE INTERRUPT ENABLE STATUS AND FLAGS
	PUSH	AX		; SAVE WORK REGISTER VALUES
	ROL	AL,1		; MOVE NMI BIT TO LOW POSITION
	STC			; FORCE NMI BIT ON IN CARRY FLAG
	RCR	AL,1		; HIGH BIT ON TO DISABLE NMI - OLD IN CY
	CLI			; DISABLE INTERRUPTS
	OUT	CMOS_PORT,AL	; ADDRESS LOCATION AND DISABLE NMI
	MOV	AL,AH		; GET THE DATA BYTE TO WRITE
	OUT	CMOS_DATA,AL	; PLACE IN REQUESTED CMOS LOCATION
	MOV	AL,CMOS_SHUT_DOWN*2 ; GET ADDRESS OF DEFAULT LOCATION
	RCR	AL,1		; PUT ORIGINAL NMI MASK BIT INTO ADDRESS
	OUT	CMOS_PORT,AL	; SET DEFAULT TO READ ONLY REGISTER
	NOP			; I/O DELAY
	IN	AL,CMOS_DATA	; OPEN STANDBY LATCH
	POP	AX		; RESTORE WORK REGISTERS
	PUSH	CS		; *PLACE CODE SEGMENT IN STACK AND
	CALL	CMOS_POPF	; *HANDLE POPF FOR B- LEVEL 80286
cw_retn:
	RETn

dow_msg:
	db 'Day of Week : '
daystr:
	db 07h
	db '??? ', 0Dh, 0Ah, 0
daytmp:	
	db "??? SUN MON TUE WED THU FRI SAT "

prg_msg:
	db 0Dh, 0Ah, 07h
	db 'Real Time Clock (CMOS) Day of Week Utility. (Real Mode - Standalone Program)'
	db 0Dh, 0Ah	
	db 'by Erdogan Tan  [01/03/2015]'
	db 0Dh, 0Ah, 0Dh, 0Ah
	db 'Press day number (1 to 7) to set.', 0Dh, 0Ah 
	db '(SUNDAY = 1 ... SATURDAY = 7)'
	db 0Dh, 0Ah, 0