; ****************************************************************************
;
; INIT05.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 29/07/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	mov si, offset copyright
	call print_msg

	xor ah, ah
	int 16h

openfile:
	mov bx, offset ttyfilename
	mov cx, 0	; open for read
	mov ax, 5	; sysopen
	int 20h
        jc error
        mov word ptr [fnumber1], ax

	mov si, offset ttyfilename
	call print_msg

        mov ax, word ptr [fnumber1]
	call hex_double
        mov word ptr [fnumber1_str], ax 
        mov word ptr [fnumber1_str]+2, dx

	mov si, offset msg_fnumber1
	call print_msg

	mov bx, offset ttyfilename
	mov cx, 1	; open for write
	mov ax, 5	; sysopen
	int 20h
        jc error
        mov word ptr [fnumber2], ax

	mov si, offset ttyfilename
	call print_msg

        mov ax, word ptr [fnumber2]
	call hex_double
        mov word ptr [fnumber2_str], ax 
        mov word ptr [fnumber2_str]+2, dx

	mov si, offset msg_fnumber2
	call print_msg

	mov si, offset nextline
	call print_msg

	xor ah, ah
	int 16h
	
writefile:
        mov bx, word ptr [fnumber2] ; file descriptor/number
	mov cx, offset prompt 	    ; buffer
	mov dx, sizeofprompt	    ; byte count
	mov ax, 4		    ; syswrite
	int 20h	
	jc short error

	or ax, ax
	jz short error	

readfile:
   	mov bx, word ptr [fnumber1] ; file descriptor/number
	mov cx, offset typedchar    ; buffer
	mov dx, 1		    ; byte count
	mov ax, 3		    ; sysread
	int 20h	
	jc short error

	or ax, ax
	jz short error				

	mov al, byte ptr [typedchar]
	
	cmp al, 1Bh
	je short closefiles	
	
	cmp al, 20h
	jnb short @f
	mov byte ptr [typedchar], 7 ; beep
@@:
	mov bx, word ptr [fnumber2] ; file descriptor/number
	mov cx, offset typedchar    ; buffer
	mov dx, 1		    ; byte count
	mov ax, 4		    ; syswrite
	int 20h	
	jc short error

	or ax, ax
	jz short error	
				
	jmp short readfile
	
closefiles:
        mov bx, word ptr [fnumber1]
	mov ax, 6 ; sysclose
	int 20h

 	;mov si, offset msg_ok
	;call print_msg

  	mov bx, word ptr [fnumber2] ; file descriptor/number
        mov cx, offset msg_ok       ; buffer
        mov dx, msg_ok_size         ; byte count
	mov ax, 4		    ; syswrite
	int 20h		

       	mov bx, word ptr [fnumber2]
	mov ax, 6 ; sysclose
	int 20h

	xor ah, ah
	int 16h

	iret
@@:
	mov ax, 1 ; 'sysexit'
	int 20h   ; UNIX system call 
		      ;	(Terminate process for DOS!)
here:	
	hlt
	jmp short here

error:
	mov si, offset msg_err
	call print_msg
        jmp short @b
 
print_msg:
	mov     AH,0Eh                  
        mov     BX,07h  
@@:
        lodsb                           ; Load byte at DS:SI to AL
        and     AL,AL            
        jz      short @f      
            
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short @b         
@@:
        retn

hex_double:
	push cx
        xor dx, dx
        mov cx, 10h
        div cx      ; Q in AX, R in DX (DL)
        push dx     ; DH= 0, R in DL <- CX= 10h 
        xor dl, dl  ;
        div cx	    ; DH= 0, R in DL, AX <= FFh
        div cl      ; AL <= 0Fh
       	            ; R in AH, Q in AL
        pop cx      ; R in CL
	mov dh, cl
	
        or dx,'00'

        cmp dl,'9'
        jna short @f
        add dl,7
@@:
        cmp dh,'9'
        jna short @f
        add dh,7
@@:
        or ax, '00'

        cmp al,'9'
        jna short @f
        add al,7
@@:
        cmp ah,'9'
        jna short @f
        add ah,7
@@:
        pop cx

        retn

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

copyRight:
		db 0Dh, 0Ah
		db 'Retro UNIX 8086 v1 <sysexec> test (for /etc/init) !'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
                db  '(c) Erdogan TAN - 29/07/2013'
		db  0Dh, 0Ah, 0	
msg_err:
		db 0Dh, 0Ah 
                db 'Error ! '
nextline:
		db 0Dh, 0Ah, 0
ttyfilename:
		db '/dev/tty0'
		db 0
fnumber1:
		dw 0 
fnumber2:	
		dw 0
buffer:
		db 512 dup(0)
msg_fnumber1:
		db ' file number (r) : '
fnumber1_str:
		dd 30303030h
		db 'h', 0Dh, 0Ah, 0
msg_fnumber2:
		db ' file number (w) : '
fnumber2_str:
		dd 30303030h
		db 'h', 0Dh, 0Ah, 0
prompt:
		db 'Retro Unix 8086 v1', 0Dh, 0Ah
		db 'login: '
sizeofprompt equ $ - offset prompt

typedchar:	
		db 0
msg_ok:	
		db 0Dh, 0Ah
		db 'OK. '
		db 0Dh, 0Ah
msg_ok_size equ $ - offset msg_ok 
		db 0

UNIX     	ends

                end     START_CODE