; ****************************************************************************
;
; INIT0.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 17/07/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	xor	si, si
	cmp	word ptr [SI], 20CDh ; Am I running in DOS ?
	jne	short @f  ; No, I am running in Retro UNIX 8086 v1.
	; Let's set 'IP' to correct offset (org 100h + offset xxx) . 
	add	si, offset copyright - offset running_msg + 100h
@@:
	add 	si, offset running_msg
	call 	unix_printmsg

	xor 	ah, ah
	int 	16h
		
	mov 	ax, 1 ; 'sysexit'
	int 	20h   ; UNIX system call 
		      ;	(Terminate process for DOS!)

unix_printmsg:
        lodsb                           ; Load byte at DS:SI to AL
        and     AL,AL            
        jz      short @f      
        mov     AH,0Eh                  
        mov     BX,07h             
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short unix_printmsg           
@@:
        retn

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

running_msg:
                db 'Retro UNIX 8086 v1 Kernel Function Test : <sysexec> Function is OK!'
                db 0Dh, 0Ah
                db '(Kernel successfully loaded and run this executable file.)'
                db 0Dh,0Ah, 0
copyRight:
		db 0Dh, 0Ah
		db 'Retro UNIX 8086 v1 <sysexec> test (for /etc/init) !'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
                db  '(c) Erdogan TAN - 17/07/2013'
		db  0Dh, 0Ah, 0	

db 3072 dup(0)

UNIX     	ends

                end     START_CODE
