; ****************************************************************************
;
; GETTY0.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 23/10/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
wtty1:
        mov bx, 1 		; standard output file (tty)
	mov cx, offset msglogin ; buffer
	mov dx, msglogin_size	; byte count
	mov ax, 4		; syswrite
	int 20h	
        jc error

	or ax, ax
        jz error 
rtty1:
	mov al, byte ptr [typedchar]
	mov byte ptr [prevtypedchar], al	
   	mov bx, 0 		 ; standard input file (tty)
	mov cx, offset typedchar ; buffer
	mov dx, 1		 ; byte count
	mov ax, 3		 ; sysread
	int 20h	
        jc error

	or ax, ax
        jz error                   

	mov al, byte ptr [typedchar]
	
	cmp al, 1Bh
	je short sh_ok	
	

	cmp al, 20h
	jnb short wtty2

	mov byte ptr [typedchar], 7 ; beep

	cmp al, 0Dh
	je short @f
wtty2:
	mov bx, 1 		 ; standard output (tty)
	mov cx, offset typedchar ; buffer
	mov dx, 1		 ; byte count
	mov ax, 4		 ; syswrite
	int 20h	
	jc short error

	or ax, ax
	jz short error	
				
	jmp short rtty1
@@:
	cmp byte ptr [prevtypedchar], 20h
	jna short sh_ok
wtty3:
	mov bx, 1 	            ; standard output (tty) 
	mov cx, offset msgnotfound  ; buffer
	mov dx, msg_nf_size	    ; byte count
	mov ax, 4		    ; syswrite
	int 20h	
	jc short error

	or ax, ax
	jz short error	

        mov bx, 1               ; standard output (tty
        mov cx, offset msg_ok   ; buffer
        mov dx, msg_ok_size     ; byte count
        mov ax, 4               ; syswrite
	int 20h		
      
   	mov bx, 0 		 ; standard input file (tty)
	mov cx, offset typedchar ; buffer
	mov dx, 1		 ; byte count
	mov ax, 3		 ; sysread
	int 20h	

        jmp start_code

fork_sh:
	mov bx, offset sh_ok ; return address for new process
	mov ax, 2	     ; sysfork	
	int 20h
	mov ax, 7	     ; syswait  	
	int 20h

        jmp start_code
sh_ok:
	mov bx, offset shell	; shell file name ("/bin/sh")
	mov cx, offset shellp	; argument (pointer to "-")
	mov ax, 11		; sysexec
	int 20h

	jmp short here
@@:
	mov ax, 1 ; 'sysexit'
	int 20h   ; UNIX system call 
		      ;	(Terminate process for DOS!)
here:	
	hlt
	jmp short here

error:
	mov si, offset msg_err
	call print_msg
        jmp short @b
 
print_msg:
	push	ds
	xor	bx, bx
	mov	ds, bx
	mov	bx, 462h
	mov	bh, byte ptr [BX] ; active display page
	pop	ds
	mov     ah, 0Eh                  
        mov     bl, 07h  
@@:
        lodsb                           ; Load byte at DS:SI to AL
        and     al,al            
        jz      short @f      
            
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short @b         
@@:
        retn

EVEN
shellp: dw shellm
        dw 0
shell:  db "/bin/sh", 0
shellm: db "-", 0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

msglogin:
		db 0Dh, 0Ah
		db 'Retro Unix 8086 v1'
		db 0Dh, 0Ah
		db 'login : '
msglogin_size 	equ $ - offset msglogin
		db 0
msg_err:
		db 0Dh, 0Ah 
                db 'Error ! '
		db 0Dh, 0Ah, 0
msgnotfound:
		db 0Dh, 0Ah
		db 'not found !'
		db 0Dh, 0Ah
msg_nf_size	equ $ - msgnotfound	
		db 0
typedchar:	
		db 0
prevtypedchar:
		db 0
msg_ok:	
		db 0Dh, 0Ah
		db 'OK. '
		db 0Dh, 0Ah
msg_ok_size 	equ $ - offset msg_ok 
		db 0

UNIX     	ends

                end     START_CODE
