; ****************************************************************************
;
; GETTY02.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 12/08/2013 ]
;
; ****************************************************************************

.8086

; UNIX v1 system calls
_rele 	equ 0
_exit 	equ 1
_fork 	equ 2
_read 	equ 3
_write	equ 4
_open	equ 5
_close 	equ 6
_wait 	equ 7
_creat 	equ 8
_link 	equ 9
_unlink	equ 10
_exec	equ 11
_chdir	equ 12
_time 	equ 13
_mkdir 	equ 14
_chmod	equ 15
_chown	equ 16
_break	equ 17
_stat	equ 18
_seek	equ 19
_tell 	equ 20
_mount	equ 21
_umount	equ 22
_setuid	equ 23
_getuid	equ 24
_stime	equ 25
_quit	equ 26	
_intr	equ 27
_fstat	equ 28
_emt 	equ 29
_mdate 	equ 30
_stty 	equ 31
_gtty	equ 32
_ilgins	equ 33

;;;
ESCKey equ 1Bh
EnterKey equ 0Dh

sys macro syscallnumber, arg1, arg2, arg3

    ; Retro UNIX 8086 v1 system call.

    ifnb <arg1> 	
      mov bx, arg1
    endif
    
    ifnb <arg2> 	
      mov cx, arg2
    endif

    ifnb <arg3> 	
      mov dx, arg3
    endif
     			
    mov ax, syscallnumber	
    int 20h	
   
    endm

; Retro UNIX 8086 v1 system call format:
; sys systemcall (ax) <arg1 (bx)>, <arg2 (cx)>, <arg3 (dx)>

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	sys _gtty, 0	; Get status of current tty
	; AL = tty number (valid if <FFh)
	inc al
	jz short @f
	dec al
@@:
	mov bh, al
	mov bl, 7
	mov ah, 0Eh
	mov si, offset msglogin
@@:	
	lodsb
	or al, al
	jz short @f
	int 10h
	jmp short @b
@@:
	xor ah, ah
	int 16h

	cmp al, 1Bh
	jz short @f 

	sys _gtty, 0	; Get status of current tty
	; AL = tty number (valid if <FFh)
	inc al
	jz short @b
	dec al
	mov bh, al
@@:	
	mov bl, 7
	mov ah, 0Eh
	mov si, offset msg_ok
@@:	
	lodsb
	or al, al
	jz short @f
	int 10h
	jmp short @b
@@:
	hlt
	jmp short @b

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

msglogin:	db 0Dh, 0Ah
		db 'Retro Unix 8086 v1'
		db 0Dh, 0Ah
		db 'login : '
 		db 0

msg_ok:		db 0Dh, 0Ah
		db 'OK. '
newline:	db 0Dh, 0Ah
		db 0

UNIX     	ends

                end     START_CODE
