; ****************************************************************************
; cftest0.s (cftest0.asm) - by Erdogan Tan - 24/04/2022
; ----------------------------------------------------------------------------
; Retro UNIX 8086 v1 - cftest-- create file test
;
; [ Last Modification: 24/04/2022 ]
;
; ****************************************************************************
; Assembler: NASM v2.15
; ((nasm cftest0.s -l cftest0.txt -o cftest0.bin -Z error.txt))
;
; 12/01/2022 (Retro UNIX 386 v1.2)
; 13/10/2015

; UNIX v1 system calls
_rele 	equ 0
_exit 	equ 1
_fork 	equ 2
_read 	equ 3
_write	equ 4
_open	equ 5
_close 	equ 6
_wait 	equ 7
_creat 	equ 8
_link 	equ 9
_unlink	equ 10
_exec	equ 11
_chdir	equ 12
_time 	equ 13
_mkdir 	equ 14
_chmod	equ 15
_chown	equ 16
_break	equ 17
_stat	equ 18
_seek	equ 19
_tell 	equ 20
_mount	equ 21
_umount	equ 22
_setuid	equ 23
_getuid	equ 24
_stime	equ 25
_quit	equ 26	
_intr	equ 27
_fstat	equ 28
_emt 	equ 29
_mdate 	equ 30
_stty 	equ 31
_gtty	equ 32
_ilgins	equ 33
_sleep	equ 34 ; Retro UNIX 8086 v1 feature only !
_msg    equ 35 ; Retro UNIX 386 v1 feature only !
_geterr	equ 36 ; Retro UNIX 386 v1 feature only !
; 12/01/2022 - Retro UNIX 386 v1.2
; Retro UNIX 386 v2 system calls
_setgid	equ 37
_getgid	equ 38
_sysver	equ 39 ; (get) Retro Unix 386 version

;;;
;ESCKey equ 1Bh
;EnterKey equ 0Dh

%macro sys 1-4
    ; Retro UNIX 8086 v1 system call.
    %if %0 >= 2   
        mov bx, %2
        %if %0 >= 3
            mov cx, %3
            %if %0 >= 4
               mov dx, %4
            %endif
        %endif
    %endif
    mov ax, %1
    int 20h
%endmacro

;-----------------------------------------------------------------
;  text - code
;-----------------------------------------------------------------

[BITS 16] ; 16-bit (x86 real mode) intructions

[ORG 0] 

START_CODE:
	; 24/04/2022

	;mov	esi, esp		
	;mov	edi, esi
	;lodsd		; number of arguments
	;;mov	edi, esi			
	;;mov	[argc], eax
	;mov	[argc], al

	; 22/04/2022
	mov	si, sp
	mov	di, si
	lodsw
	;;mov	[argc], ax
	;mov	[argc], al

	;if (argc <> 2) 
	;   goto usage;

	;cmp	ax, 2
	cmp	al, 2
	je	short cf_0
	ja	short cf_usage

	;sys	_msg, program_msg, 255, 0Fh
	; 22/04/2022
	mov	ax, program_msg ; asciiz message address
	call	print_msg
cf_usage:
   	;sys	_msg, usage_msg, 255, 07h
	mov	ax, usage_msg
cf_err_exit:
cf_ok_exit:
	call	print_msg
cf_exit:
	sys	_exit	; sys exit
;hlt:
;	nop
;	nop
;	jmp	short hlt

print_msg:
	; 22/04/2022
	; Modified registers: ax, bx, cx, dx
strlen:
	; ax = asciiz string address
	mov	bx, ax
	dec	bx
nextchr:
	inc	bx
	cmp	byte [bx], 0
	ja	short nextchr
	;cmp	[bx], 0Dh
	;ja	short nextchr
	sub	bx, ax
	; bx = asciiz string length
	;retn
print_str:
	mov	dx, bx
	sys	_write, 1, ax

	retn

cf_0:
	lodsw	; bypass argument 1 

	sys	_stat, [si], stbuf
	jc	short cf_1

	mov	ax, err_file_exists
	jmp	short cf_err_exit

cf_1:
	sys	_creat, [si], 01110b ; rwr-
	jnc	short cf_2

	mov	ax, err_cannot_create
	jmp	short cf_err_exit

cf_2:
	mov	si, ax ; file number

	sys	_write, si, iobuf, textsize
	jnc	short cf_3	

	sys	_close, si

	mov	ax, err_write
	jmp	short cf_err_exit

	; eof
cf_3:
	sys	_close, si
	
	mov	ax, ok_msg
	jmp	short cf_ok_exit
	
;-----------------------------------------------------------------
;  data - initialized data
;-----------------------------------------------------------------

;;argc:	dd 0
;argc:	db 0

iobuf:	db 0Dh, 0Ah
	db "At the moment, you are reading 'Create File Test (cftest)' "
	db "program output. I have written this test utility/program "
	db "for understanding cp -copy file- failure reason while "
	db "creating a new file in any directory. So, I will understand"
	db " that retro unix 8086 create file system call is defective "
	db "or not. ('cp' utility uses sysread and syswrite systems calls "
	db " together in a loop. It was difficult to understand if "
	db "the failure/freezing occurs at create stage or r/w stage.)"
	db  0Dh, 0Ah, 0Dh, 0Ah
	db "Erdogan Tan - 24/04/2022"
	db 0Dh, 0Ah, 0

textsize equ ($-iobuf) - 1		
	
; ----------------------------------------------------------------

program_msg:
	db  0Dh, 0Ah
	db  'Retro UNIX v1 CREATE FILE TEST by Erdogan TAN - 24/04/2022'
	;db 0Dh, 0Ah
	db  0
usage_msg:
	db  0Dh, 0Ah
	db  'Usage: cftest filename'
nextline:
	db  0Dh, 0Ah, 0

err_file_exists:
	db 0Dh, 0Ah
	db 'cftest: file exists !'
	db 0
err_cannot_create:
	db 0Dh, 0Ah
	db 'cftest: cannot create file !'
	db 0Dh, 0Ah, 0

err_write:
	db 'cftest: write error.'
	db 0Dh, 0Ah, 0

ok_msg:
	db  0Dh, 0Ah
	db  'cftest: OK.'
	db  0Dh, 0Ah, 0

;errors: db 0

;-----------------------------------------------------------------
;  bss - uninitialized data
;-----------------------------------------------------------------

align 2

bss_start:

ABSOLUTE bss_start

;fnum:	resw 1

stbuf: resb 34