.model tiny
.code
.startup

	; org 100h

	JMP INSTALL
	ADD9 DD ?
;ISR to generate beep sound
beepISR PROC FAR
	PUSH AX
	PUSH BX
	PUSH CX
	PUSH DX
	IN AL,61H
	OR AL,03H
	OUT 61H,AL ; Turn ON system speaker
	MOV AL,0B6H ; program Counter 2
	OUT 43H,AL
	MOV BX,2000
	MOV AX,34DCH
	MOV DX,12H
	DIV BX
	OUT 42H,AL ;set the frequency of counter 2 to 2000Hz
	MOV AL,AH
	OUT 42H,AL
	MOV CX,1FFFH
BACK2:
	MOV DX,0FFFFH ; Delay
BACK1:
	DEC DX
	JNZ BACK1
	LOOP BACK2
	IN AL,61H
	XOR AL,03H ; Turn OFF system speaker
	OUT 61H,AL
	PUSHF
	CALL CS:ADD9 ; Call original ISR9
	POP DX
	POP CX
	POP BX
	POP AX
	IRET
beepISR ENDP
INSTALL:
	MOV AX,CS
	MOV DS,AX ; overlap CS and DS
	MOV AH,35H
	MOV AL,09H
	INT 21H
	MOV WORD PTR ADD9,BX
	MOV WORD PTR ADD9+2,ES ;Get the current vector 9 and save it in ADDR9
	MOV AH,25H
	MOV AL,09H
	MOV DX,OFFSET beepISR ;install beepISR at Vector 9
	INT 21H
	MOV DX,OFFSET INSTALL
	MOV CL,4
	SHR DX,CL ; find the paragraph size in Dx
	INC DX
	MOV AH,31H ; exit to DOS as TSR
	MOV AL,00H
	INT 21H
end
