; Setup CMOS RTC date & time parameters
; RTCSETUP.S (Standalone Program for Real Mode)
; by Erdogan Tan (01/03/2015)
; ((Assembler: NASM 2.11))

; Last Update: 03/03/2015
;
;; Programming purpose:
;; Day of Week value (CMOS Register 6)
;; is (can) not changed/updated via ROM BIOS.
;; So, it is needed to change
;; this value with a special utility. 
;; (SUNDAY = 1, .... SATURDAY = 7)
;; If it is not changed, programs which
;; use Real Time Clock and CMOS Day Of Week value
;; will show wrong day but (with) correct date and time.
;; For example: 01/03/2015 (March 1, 2015)
;, is Sunday but my computer shows 'SAT' instead of
;; 'SUN' (ASUS M2TVM main board, AMD 64 Athlon CPU,
;;  AWARD BIOS, 2004).
;, The ROM BIOS uses internal calculation method
;; without regarding CMOS Day of Week (register) value.
;; It is not possible to change this CMOS register value
;  by using ROM BIOS.
;; 	
;, /// Assembly source code is modified from (dsectpm.s)
;; Retro UNIX 386 v1 DISK I/O Test program (unix386.s) - 28/02/2015 ///
;; (dsectrpm.s, dsectrm2.s, drvinit.inc, diskette.inc, disk.inc)

ESCKey	 equ 1Bh    ;27		
ENTERKey equ 0Dh    ;13
PlusKey  equ 2Bh    ;43
MinusKey equ 2Dh    ;45
SPACEbar equ 20h    ;32	  	

; IBM PC/XT Model 286 BIOS ----- 10/06/85 (postequ.inc)
;--------- CMOS TABLE LOCATION ADDRESS'S -------------------------------------
CMOS_SECONDS	EQU	00H		; SECONDS (BCD)
CMOS_MINUTES	EQU	02H		; MINUTES (BCD)	
CMOS_HOURS	EQU	04H		; HOURS (BCD)
CMOS_DAY_WEEK	EQU	06H		; DAY OF THE WEEK  (BCD)
CMOS_DAY_MONTH	EQU	07H		; DAY OF THE MONTH (BCD) 
CMOS_MONTH	EQU	08H		; MONTH (BCD)
CMOS_YEAR	EQU	09H		; YEAR (TWO DIGITS) (BCD)
CMOS_CENTURY	EQU	32H		; DATE CENTURY BYTE (BCD)
CMOS_REG_A	EQU	0AH		; STATUS REGISTER A
CMOS_REG_D	EQU	0DH		; STATUS REGISTER D  BATTERY
CMOS_SHUT_DOWN	EQU	0FH		; SHUTDOWN STATUS COMMAND BYTE
;----------------------------------------
;	CMOS EQUATES FOR THIS SYSTEM	;
;-----------------------------------------------------------------------------
CMOS_PORT	EQU	070H		; I/O ADDRESS OF CMOS ADDRESS PORT
CMOS_DATA	EQU	071H		; I/O ADDRESS OF CMOS DATA PORT
NMI		EQU	10000000B	; DISABLE NMI INTERRUPTS MASK -
					; HIGH BIT OF CMOS LOCATION ADDRESS

; Window border and text positions
RtcWinWidth	equ 	22
RtcWinHeight	equ	5
RtcWinPosR	equ	9 ; ((25 - 5)/2)-1
RtcWinPosC	equ	28 ; ((80 - 22) / 2)-1
RtcWinStart	equ	(RtcWinPosR*80*2) + (RtcWinPosC*2) 
Row1Start	equ	RtcWinStart+(80*2)+2 
Row2Start	equ	Row1Start+(80*2)
Row3Start	equ	Row2Start+(80*2)
LabelSize	equ	9 ; ('Date  :  ')
HourPos		equ	Row1Start+(LabelSize*2)  ; hour
MinutePos	equ	Row1Start+(LabelSize*2)+(2*3) ; minute
SecondPos	equ	Row1Start+(LabelSize*2)+(2*6) ; second
DayPos		equ	Row2Start+(LabelSize*2)  ; day
MonthPos        equ     Row2Start+(LabelSize*2)+(2*3) ; month
YearPos		equ	Row2Start+(LabelSize*2)+(2*6) ; year
DowPos		equ	Row3Start+(LabelSize*2) ; day of week

[BITS 16]

	org 100h  ; Org 100h (Offset 100h) for DOS *.COM files
		  ; ZERO offset for Retro UNIX 8086 v1 boot 
		  ; (standalone program) files
	;
        mov     si, prg_msg
print_msg:	
	mov	bx, 7
	mov	ah, 0Eh
prt_msg_loop:
	lodsb
	and	al, al
	jz	short prt_msg_ok
	int 	10h
	jmp	short prt_msg_loop

prt_msg_ok:
	mov	ah, 10h
	int	16h
	;
	xor	bh, bh
	mov	ah, 03h	; get cursor position and shape
	int	10h
	mov	[cursor_posn], dx ; position ;; 16/02/2015
	;
hide_cursor:
        mov 	ch, 32
        mov 	cl, 7
        mov 	ah, 1
        int 	10h
	;
clear_screen:
	mov	ah, 0Fh ; get video mode
        int     10h
	; al = video mode
        mov 	ah, 0   ; set video mode (clears screen)
        int 	10h
;hide_cursor: ; hide cursor again
        mov 	ch, 32
        mov 	cl, 7
        mov 	ah, 1
        int 	10h
	;
display_rtcs_window:
	mov	ax, 0B800h
	mov	es, ax	
	mov	di, RtcWinStart
	mov	cx, RtcWinHeight
	mov	ah, 17h ; Blue backcolor, light gray forecolor
	mov	al, 20h
rtcswl:
	push	di
	push	cx
	mov	cx, RtcWinWidth
	rep	stosw		
	pop	cx
	pop	di
	dec	cx
	jz	short rtcs_getc
	add	di, 80*2
	jmp	short rtcswl

rtcs_getc:
	call	display_rtc_data
	; getchar - check keyboard buffer
	mov	ah, 11h
	int	16h
	jz	short rtcs_getc 
	; getchar
	mov	ah, 10h
	int	16h
	;
	cmp	al, ESCKey
        je      short rtcs_exit
	cmp	al, ENTERKey
        je	short rtcs_nextf
	cmp	al, PlusKey
	je	short rtcs_pluscf
	cmp	al, MinusKey
	je	short rtcs_minuscf
	cmp	al, SPACEbar
	je	short rtcs_nextf	
	jmp	short rtcs_getc

rtcs_exit:
show_cursor:
	sub	bl, bl	; video page 0
set_cpos:
	mov	dx, [cursor_posn] ; dh = row, dl = column
	; DX = cursor position
	mov	ah, 02h		; Set cursor position
	xor	bh, bh		; for video page 0
	int	10h
	;show box-shaped blinking text cursor
	mov	ch, 6
        mov 	cl, 7
        mov 	ah, 1
        int 	10h
	;
	int 	20h ; Terminate process (program)
	;
	int	19h ; Reboot (for standalone program)
;nevercomehere:
;	jmp	short nevercomehere

rtcs_nextf:
	call	next_field
	jmp	short rtcs_getc

rtcs_pluscf:
	call	get_rtc_value
	inc	al
	call	set_rtc_value
	jmp	short rtcs_getc

rtcs_minuscf:
	call	get_rtc_value
	dec	al
	call	set_rtc_value
	jmp	short rtcs_getc

get_rtc_value:
	mov	ah, [c_field]
	and	ah, ah
	jz	short rtcs_nextf
	;
	cmp	ah, 3 ; current pos on time row
	ja	short grtcv4
	cmp	ah, 2 
	ja	short grtcv2
	jb	short grtcv1
	;
	mov	al, [time_minutes]
	jmp	short bcd_to_bin
grtcv1:
	mov	al, [time_hours]
	jmp	short bcd_to_bin
grtcv2:
	mov	al, [time_seconds]
grtcv3:
	;call	bcd_to_bin	
	;retn
bcd_to_bin:
	; AL = BCD number (<=99h)
  	db 	0D4h,10h	; Undocumented inst. AAM
				; AH = AL / 10h
				; AL = AL MOD 10h
        aad ; AX= AH*10+AL
	; AL = Binary number (byte, <= 63h)
	; AH = 0
	retn
grtcv4:
	cmp	ah, 6 ; current pos on date row
	ja	short grtcv7
	cmp	ah, 5 
	ja	short grtcv6
	jb	short grtcv5
	;
	mov	al, [date_month]
	jmp	short bcd_to_bin
grtcv5:
	mov	al, [date_day]
	jmp	short bcd_to_bin
grtcv6:
	mov	al, [date_century]
	call 	bcd_to_bin
	mov 	dl, al
	mov	al, [date_year]
	call 	bcd_to_bin
	mov	ah, dl	
	retn
grtcv7:	; DOW position
	mov 	al, [date_wday]
	jmp	short bcd_to_bin

set_rtc_value:
	mov	dl, [c_field]
	;and	dl, dl
	;jz	short rtcs_nextf
	;
	cmp	dl, 3 ; current pos on time row
	ja	short srtcv4
	cmp	dl, 2 
	ja	short srtcv2
	jb	short srtcv1
	;
	cmp	al, 60
	jnb	short srtcm60
	call	bin_to_bcd
	jmp 	short srtcvmi
srtcm60:
	sub	al, al ; 0
srtcvmi:
	mov	ah, CMOS_MINUTES
	jmp	short srtcv3
srtcv1:
	cmp	al, 24
	jnb	short srtch24
	call	bin_to_bcd
	jmp	short srtcvho
srtch24:
	sub	al, al ; 0
srtcvho:
	mov	ah, CMOS_HOURS
	jmp	short srtcv3
srtcv2:
	cmp	al, 60
	jnb	short srtcs60
	call	bin_to_bcd
	jmp 	short srtcvse
srtcs60:
	sub	al, al ; 0
srtcvse:
	mov	ah, CMOS_SECONDS
	jmp 	short srtcv3	
srtcv4:
	cmp	dl, 6 ; current pos on date row
	ja	short srtcv7
	je	short srtcv6
	cmp	dl, 4 
	je	short srtcv5
	;
	cmp	al, 12
	ja	short srtcm12
	and	al, al
	jnz	short srtcm0
	mov	al, 12h ; BCD number
	jmp	short srtcvmo
srtcm0:
	cmp	al, 9
	jna	short srtcvmo
	call	bin_to_bcd
	jmp	short srtcvmo
srtcm12:
	mov	al, 1
srtcvmo:
	mov	ah, CMOS_MONTH
srtcv3:
	call	write_cmos
	retn
srtcv5:
	mov	dl, al
	mov	al, [date_year]
	call	bcd_to_bin
	and	al, 3
	jz	short srtcvly
        mov     byte [monthtmp+1], 28
	jmp	short srtcvnly
srtcvly:
	mov	byte [monthtmp+1], 29
srtcvnly:
	mov 	al, [date_month]
	call	bcd_to_bin
	xor	bh, bh
	mov	bl, al ; 1 to 12
	add	bx, monthtmp - 1 ; 0 to 11
	mov 	ah, [bx]
	mov	al, dl
	cmp	al, ah
	ja	short srtcd31
	and	al, al
	jnz	short srtcd0
	mov	al, ah
srtcd0:
	call	bin_to_bcd
	jmp	short srtcvdm
srtcd31:
	mov	al, 1
srtcvdm:
	mov	ah, CMOS_DAY_MONTH
	jmp	short srtcv3
srtcv6:
	push	ax
	mov 	al, 20h ; BCD number
	mov	ah, CMOS_CENTURY
	call	srtcv3
	pop	ax
	call	bin_to_bcd
	mov	ah, CMOS_YEAR
	jmp	short srtcv3
	
srtcv7:	; DOW position
	cmp 	al, 7
	jna	short srtcdow1
	mov	al, 1 ; SUN
	jmp	short srtcdow2
srtcdow1:
	and	al, al
	jnz	short srtcdow2
	mov	al, 7
srtcdow2:
	mov	ah, CMOS_DAY_WEEK
	jmp	short srtcv3

time_of_day:
	call	UPD_IPR		; WAIT TILL UPDATE NOT IN PROGRESS
        jc      short tod_retn 
	mov	al, CMOS_SECONDS
	call	CMOS_READ
	mov	byte [time_seconds], al 
	mov	al, CMOS_MINUTES
	call	CMOS_READ
	mov	byte [time_minutes], al 
	mov	al, CMOS_HOURS
	call	CMOS_READ
        mov     byte [time_hours], al
	mov	al, CMOS_DAY_WEEK 
	call	CMOS_READ
	mov	byte [date_wday], al
 	mov	al, CMOS_DAY_MONTH
	call	CMOS_READ
	mov	byte [date_day], al
	mov	al, CMOS_MONTH
	call	CMOS_READ
	mov	byte [date_month], al
	mov	al, CMOS_YEAR
	call	CMOS_READ
	mov	byte [date_year], al
	mov	al, CMOS_CENTURY
	call	CMOS_READ
	mov	byte [date_century], al
	;
	mov	al, CMOS_SECONDS
	call 	CMOS_READ
	cmp	al, byte [time_seconds]
	jne	short time_of_day
tod_retn:
	retn

	; IBM PC/XT Model 286 BIOS source code ----- 10/06/85 (test4.asm)
CMOS_READ:			; READ LOCATION (AL) INTO (AL)
	PUSHF			; SAVE INTERRUPT ENABLE STATUS AND FLAGS
	ROL	AL,1		; MOVE NMI BIT TO LOW POSITION
	STC			; FORCE NMI BIT ON IN CARRY FLAG
	RCR	AL,1		; HIGH BIT ON TO DISABLE NMI - OLD IN CY
	CLI			; DISABLE INTERRUPTS
	OUT	CMOS_PORT,AL	; ADDRESS LOCATION AND DISABLE NMI
	NOP			; I/O DELAY
	IN	AL,CMOS_DATA	; READ THE REQUESTED CMOS LOCATION
	PUSH	AX		; SAVE (AH) REGISTER VALUE AND CMOS BYTE
	MOV	AL,CMOS_SHUT_DOWN*2 ; GET ADDRESS OF DEFAULT LOCATION
	RCR	AL,1		; PUT ORIGINAL NMI MASK BIT INTO ADDRESS
	OUT	CMOS_PORT,AL	; SET DEFAULT TO READ ONLY REGISTER
	NOP			; I/O DELAY
	IN	AL,CMOS_DATA	; OPEN STANDBY LATCH
	POP	AX		; RESTORE (AH) AND (AL), CMOS BYTE
	PUSH	CS		; *PLACE CODE SEGMENT IN STACK AND
	CALL	CMOS_POPF	; *HANDLE POPF FOR B- LEVEL 80286
	RETn			; RETURN WITH FLAGS RESTORED

CMOS_POPF:			; POPF FOR LEVEL B- PARTS
	IRET			; RETURN FAR AND RESTORE FLAGS	

	; IBM PC/XT Model 286 BIOS source code ----- 10/06/85 (bios2.asm)
UPD_IPR:			; WAIT TILL UPDATE NOT IN PROGRESS
	PUSH	CX		; SAVE CALLERS REGISTER
	;MOV	CX,800		; SET TIMEOUT LOOP COUNT
	xor	cx, cx
UPD_10:
	MOV	AL,CMOS_REG_A	; ADDRESS STATUS REGISTER A
	CLI			; NO TIMER INTERRUPTS DURING UPDATES
	CALL	CMOS_READ	; READ UPDATE IN PROCESS FLAG
	TEST	AL,80H		; IF UIP BIT IS ON ( CANNOT READ TIME )
	JZ	short UPD_90	; EXIT WITH CY= 0 IF CAN READ CLOCK NOW
	STI			; ALLOW INTERRUPTS WHILE WAITING
	LOOP	UPD_10		; LOOP TILL READY OR TIMEOUT
	XOR	AX,AX		; CLEAR RESULTS IF ERROR
	STC			; SET CARRY FOR ERROR
UPD_90:
	POP	CX		; RESTORE CALLERS REGISTER
	CLI			; INTERRUPTS OFF DURING SET
	RETn			; RETURN WITH CY FLAG SET

write_cmos:
	xchg	ah, al		; al = location, ah = value
	push	ax
	CALL	UPD_IPR		; CHECK FOR UPDATE IN PROCESS
	pop	ax
	jc	short tod_retn

	; IBM PC/XT Model 286 BIOS source code ----- 10/06/85 (test4.asm)
CMOS_WRITE:			; WRITE (AH) TO LOCATION (AL)
	PUSHF			; SAVE INTERRUPT ENABLE STATUS AND FLAGS
	PUSH	AX		; SAVE WORK REGISTER VALUES
	ROL	AL,1		; MOVE NMI BIT TO LOW POSITION
	STC			; FORCE NMI BIT ON IN CARRY FLAG
	RCR	AL,1		; HIGH BIT ON TO DISABLE NMI - OLD IN CY
	CLI			; DISABLE INTERRUPTS
	OUT	CMOS_PORT,AL	; ADDRESS LOCATION AND DISABLE NMI
	MOV	AL,AH		; GET THE DATA BYTE TO WRITE
	OUT	CMOS_DATA,AL	; PLACE IN REQUESTED CMOS LOCATION
	MOV	AL,CMOS_SHUT_DOWN*2 ; GET ADDRESS OF DEFAULT LOCATION
	RCR	AL,1		; PUT ORIGINAL NMI MASK BIT INTO ADDRESS
	OUT	CMOS_PORT,AL	; SET DEFAULT TO READ ONLY REGISTER
	NOP			; I/O DELAY
	IN	AL,CMOS_DATA	; OPEN STANDBY LATCH
	POP	AX		; RESTORE WORK REGISTERS
	PUSH	CS		; *PLACE CODE SEGMENT IN STACK AND
	CALL	CMOS_POPF	; *HANDLE POPF FOR B- LEVEL 80286
	RETn

bcd_to_text:
	; AL = BCD number (<= 99h)
	db 	0D4h,10h	; Undocumented inst. AAM
				; AH = AL / 10h
				; AL = AL MOD 10h
	or 	ax,'00' 	; Make it ASCII based
        xchg 	ah, al
	; AL = '0' ... '9' (1st byte of the text)
	; AH = '0' ... '9' (2nd byte of the text)
rtc_retn:
	retn

bin_to_bcd:
	; AL = Binary Number  (<= 63h, <= 99)
	aam 	; ah = al / 10, al = al mod 10
	db 	0D5h,10h 	; Undocumented inst. AAD
				; AL = AH * 10h + AL
	; AL = BCD Number (<= 99h)
	; AH = 0 to 15
	retn

;text_to_bcd:
;	; AX = '00' ... '99'
;	sub 	ax, '00'
;		; AL = 0 to 9 (msb)
;		; AH = 0 to 9 (lsb)
;	shl	al, 4 ; high nibble of BCD number (0 to 9)
;	add	al, ah ; low nibble of BCD bumber	
;	; AL = BCD number (0 to 99h)
;	; AH =  0 to 9
;	retn

;text_to_bin:
;	; AX = '00' ... '99'
;	sub 	ax, '00'
;		; AL = 0 to 9 (msb)
;		; AH = 0 to 9 (lsb)
;	xchg 	ah, al
;		; Unpacked BCD digits in AH, AL
;	aad	; AL = AH * 10 + AL
;		; AH = 0
;	retn

display_rtc_data:	
 	call	time_of_day
	jc	short rtc_retn
	;
	cmp	al, byte [ptime_seconds]
        je      short rtc_retn
	;
	mov	byte [ptime_seconds], al
	;
	mov	al, byte [date_century]
	call	bcd_to_text
	mov	word [datestr+6], ax
	mov	al, byte [date_year]
	call	bcd_to_text
	mov	word [datestr+8], ax
	mov	al, byte [date_month]
	call	bcd_to_text
	mov	word [datestr+3], ax
	mov	al, byte [date_day]
	call	bcd_to_text
	mov	word [datestr], ax
	;
	xor	bh, bh
	mov	bl, byte [date_wday]
	shl 	bl, 2
	add	bx, daytmp
	mov	ax, word [bx]
	mov	word [daystr], ax
	mov	ax, word [bx+2]
	mov	word [daystr+2], ax
	;
	mov	al, byte [time_hours]
	call	bcd_to_text
	mov	word [timestr], ax
	mov	al, byte [time_minutes]
	call	bcd_to_text
	mov	word [timestr+3], ax
	mov	al, byte [time_seconds]
	call	bcd_to_text
	mov	word [timestr+6], ax
	;
	mov	si, rtc_row1 ; time label and data row
	mov	di, Row1Start
	call	prtr_loop
	mov	si, rtc_row2 ; date label and data row
	mov	di, Row2Start
	call	prtr_loop
	mov	si, rtc_row3 ; date label and data row
	mov	di, Row3Start
prtr_loop:
	lodsb
	or	al, al
	jz	short prtr_ok
	stosb
	inc	di
	jmp	short prtr_loop	
prtr_ok:
	retn

next_field:
	mov	ah, [c_field]
	or	ah, ah
	jz	short next_field_1
	; clear rtc data window (clear focus)
	mov	al, 17h ; blue background, light gray forecolor
	call	set_focus
	cmp	ah, 7
	jb	short next_field_1
	sub	ah, ah ; 0	
next_field_1:
	inc	ah 
	mov	[c_field], ah
	;retn
	mov	al, 1Fh ; blue background, white forecolor
set_focus:
	;mov 	ah, [c_field]
	;and	ah, ah
	;jz	short set_focus_retn
	cmp	ah, 3 ; last pos on time row
	ja	short set_focus_1
	cmp	ah, 1
	ja	short sf1a
	mov	di, HourPos
	jmp	short set_focus_retn
sf1a:
	cmp	ah, 2
	ja	short sf1b
	mov	di, MinutePos
	jmp	short set_focus_retn
sf1b:
	mov	di, SecondPos
	jmp	short set_focus_retn
set_focus_1:
	cmp	ah, 6 ; last pos date row
	ja	short set_focus_2
	cmp	ah, 4
	ja	short sf2a
	mov	di, DayPos
	jmp	short set_focus_retn
sf2a:
	cmp	ah, 5
	ja	short sf2b
	mov	di, MonthPos
	jmp	short set_focus_retn
sf2b:
	mov	di, YearPos + 1
	stosb
	inc	di
	stosb
	jmp	short set_focus_retn
set_focus_2:
	mov	di, DowPos + 1
	stosb
set_focus_retn:
	inc	di
	stosb
	inc	di
	stosb
	retn

c_field: ; current field (pos1 to pos7)  
	db 0 ; it is used for changing current field color (focus)

; 22/08/2014 (RTC)
; (Packed BCD)
time_seconds: db 0
time_minutes: db 0
time_hours:   db 0
date_wday:    db 0
date_day:     db 0
date_month:   db 0			
date_year:    db 0
date_century: db 0

ptime_seconds: db 0FFh

rtc_row1:
	db 'Time  :  '
timestr:
	dd '00:00:00', 0
rtc_row2:
	db 'Date  :  ' 
datestr:
	db '00/00/0000', 0
rtc_row3:
	db 'Day   :  '
daystr:
	db '??? ', 0
daytmp:	
	db "??? SUN MON TUE WED THU FRI SAT "

monthtmp:
	db 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31

cursor_posn: dw 0

prg_msg:
	db 0Dh, 0Ah, 07h
	db 'Real Time Clock (CMOS) Setup Utility. (Real Mode - Standalone Program)'
	db 0Dh, 0Ah	
	db 'by Erdogan Tan  [03/03/2015]'
	db 0Dh, 0Ah, 0Dh, 0Ah
	db 'Keys: ', 0Dh, 0Ah 
	db '   + = Increase value', 0Dh, 0Ah 
	db '   - = Decrease value', 0Dh, 0Ah 
	db '   ENTER = Next Field', 0Dh, 0Ah 
	db '   ESC = EXIT', 0Dh, 0Ah, 0Dh, 0Ah 
	db '(Press any key to continue...)'
	db 0Dh, 0Ah
	db 0Dh, 0Ah, 0
